import java.io.*;
import java.util.*;
import java.math.*;

public class H implements Runnable {
	private static BufferedReader in;
	private static StringTokenizer st;
	private static PrintWriter out;

	public static class Tuple {
		double a, b, c;
		boolean type;

		public Tuple(double a, double b, double c, boolean type) {
			this.a = a;
			this.b = b;
			this.c = c;
			this.type = type;
		}

		@Override
		public String toString() {
			return "Tuple [a=" + a + ", b=" + b + ", c=" + c + ", type=" + type
					+ "]";
		}

		public static Tuple merge(Tuple a, Tuple b) {
			if (a == null) {
				return b;
			} else if (a.type && b.type) {
				return lineByPoints(a, b);
			} else if (a.type) {
				return reverse(b, a);
			} else if (b.type) {
				return reverse(a, b);
			} else {
				return intersectLines(a, b);
			}
		}

		private static Tuple intersectLines(Tuple x, Tuple y) {
			if (x.type || y.type) {
				throw new AssertionError();
			}
			double A = x.a * y.b - x.b * y.a;
			double B = (-x.c) * y.b - x.b * (-y.c);
			double C = x.a * (-y.c) - (-x.c) * y.a;

			double xp = B / A;
			double yp = C / A;

			return new Tuple(xp, yp, 0, true);
		}

		private static Tuple reverse(Tuple line, Tuple point) {
			if (line.type || !point.type)
				throw new AssertionError();

			double A = -line.b;
			double B = line.a;
			double C = line.b * point.a - line.a * point.b;

			Tuple resultLine = new Tuple(A, B, C, false);

			Tuple newPoint = intersectLines(line, resultLine);

			double dx = newPoint.a - point.a;
			double dy = newPoint.b - point.b;

			return new Tuple(point.a + 2 * dx, point.b + 2 * dy, 0.0, true);
		}

		public static Tuple lineByPoints(Tuple a, Tuple b) {
			if (!a.type || !b.type)
				throw new AssertionError();

			double x0 = a.a, y0 = a.b;
			double x1 = b.a, y1 = b.b;

			double A = y1 - y0;
			double B = x0 - x1;
			double C = y0 * x1 - x0 * y1;

			return new Tuple(A, B, C, false);
		}
	}

	private Tuple rec(String s) {
		//out.println(s);
		//out.flush();
		if (s.charAt(0) != '(') {
			String[] tokens = s.split(",");
			if (tokens.length != 2) {
				throw new AssertionError();
			}
			double x = Double.parseDouble(tokens[0]);
			double y = Double.parseDouble(tokens[1]);
			return new Tuple(x, y, 0.0, true);
		} else {
			int n = s.length();
			int[] skip = new int[n];
			Arrays.fill(skip, -1);
			Stack<Integer> st = new Stack<>();
			for (int i = 0; i < s.length(); i++) {
				char c = s.charAt(i);
				if (c == '(') {
					st.add(i);
				} else if (s.charAt(i) == ')') {
					int p = st.pop();
					skip[p] = i + 1;
				}
			}
			Tuple result = null;
			int cursor = 0;
			while (cursor < s.length()) {
				if (skip[cursor] != -1) {
					String newS = s.substring(cursor + 1, skip[cursor] - 1);
					Tuple newResult = rec(newS);
					result = Tuple.merge(result, newResult);
					cursor = skip[cursor];
				} else if (s.charAt(cursor) == '@') {
					++cursor;
				} else {
					throw new AssertionError();
				}
			}
			return result;
		}
	}

	private boolean solveOne() throws IOException {
		String s = nextToken();
		if (s.equals("#"))
			return false;
		Tuple result = rec(s);
		if (result.type != true)
			throw new AssertionError();
		out.println(result.a + " " + result.b);
		return true;
	}

	private void solve() throws IOException {
		while (solveOne())
			;
	}

	public void run() {
		final String className = this.getClass().getName().toLowerCase();

		try {
			try {
				in = new BufferedReader(new FileReader(className + ".in"));
				out = new PrintWriter(new FileWriter(className + ".out"));
			} catch (FileNotFoundException e) {
				in = new BufferedReader(new InputStreamReader(System.in));
				out = new PrintWriter(System.out);
			}

			solve();

			out.close();
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	public static void main(String[] args) {
		new H().run();
		// new Thread(null, new Template(), "Template", (1L << 24)).start();
	}

	private String nextToken() throws IOException {
		while (st == null || !st.hasMoreTokens()) {
			String line = in.readLine();
			if (line == null) {
				return null;
			}
			st = new StringTokenizer(line);
		}
		return st.nextToken();
	}

	private int nextInt() throws IOException {
		return Integer.parseInt(nextToken());
	}

	private long nextLong() throws IOException {
		return Long.parseLong(nextToken());
	}

	private double nextDouble() throws IOException {
		return Double.parseDouble(nextToken());
	}

}
